<?php

require_once("vbautil/class_xml.php");
require_once "vbautil/build_vbamodule_utils.php";

$dirs = array(
	"standard" => array("php"=>"../vba_modules/php", "template"=>"../vba_modules/templates", "module"=>"../../release/vba_modules"),
	);

$ldm_linkbit_tocache = "
    links_downloadbit,
    links_editbit,
    links_entitymarkupbit,
    links_favbit,
    links_imgmag,
    links_JWplayer_header,
    links_JWwmplayer_header,
    links_keysbit,
    links_likebit,
    links_linkseparator,
    links_nominatebit,
    links_nominated_leaderbit,
    links_othercatsbit,
    links_playerbit_JWPlayer,
    links_playerbit_JWwmPlayer,
    links_playerbit_WimpyButton,
    links_ratebit_ajax,
    links_ratebit_dropdown,
    links_ratebit_inline,
    links_reportlinkbit,
    links_sendtofriendbit,
    links_subcatbit,
	links_viewone_entity,
	links_viewone_inline_comment,
    links_WimpyButton_header,
	";

$perrow = "3";
$toshow = "12";
$torevw = "5";

foreach ($dirs as $which=>$dir) {

	$codedir = $dir["php"];
	$templatedir = $dir["template"];
	$outputdir = $dir["module"];

	echo "Now building ".$which." modules\n";
	echo "PHP code read from ".$codedir."\n";
	echo "Templates read from ".$templatedir."\n";
	echo "Modules written to ".$outputdir."\n";

// Category-related modules --------------------

// Main Categories module

	$vba_module = create_vba_module("Categories", "ldm_cats", $codedir."/ldm_cats.php", $templatedir."/ldm_cats.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_cats_base_category", "adv_portal_ldm_cats", "Categories", "Comma-separated list of category ids; -1=base category", "", "-1", "-1");
	add_vba_setting($vba_module, "portal_ldm_cats_showperrow", "adv_portal_ldm_cats", "Columns Display", "Categories to show per row", "", "1", "1");
	add_vba_setting($vba_module, "portal_ldm_cats_depth_display", "adv_portal_ldm_cats", "Depth Display", "=0: List specified categories only; >0 List their child categories to this depth", "", "1", "1");
	add_vba_setting($vba_module, "portal_ldm_cats_sub_display", "adv_portal_ldm_cats", "Subcategory Display", "Depth of categories below depth_display shown as links within the catbit", "", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_cats.module");
	echo "Created Main Categories module\n";

// Newest Categories module

	$vba_module = create_vba_module("Categories with New Entries", "ldm_newcats", $codedir."/ldm_newcats.php", $templatedir."/ldm_newcats.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_newcats_showentries", "adv_portal_newcats", "Entries", "Number of newest categories to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_newcats_showperrow", "adv_portal_newcats", "Per row", "Categories to show per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_newcats_showcategories", "adv_portal_ldm_newcats", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_newcats_showpagenav", "adv_portal_ldm_newcats", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_newcats.module");
	echo "Created Newest Categories module\n";

// Entry-related modules --------------------

// What's Hot module

	$vba_module = create_vba_module("What's Hot", "ldm_hot", $codedir."/ldm_hot.php", $templatedir."/ldm_hot.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_hot_showentries", "adv_portal_ldm_hot", "Entries", "Number of hot entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_hot_showperrow", "adv_portal_ldm_hot", "Per row", "Entries to show per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_hot_hitssince", "adv_portal_ldm_hot", "Days", "Number of days over which to count.  Set to zero to count all hits", "", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_showcategories", "adv_portal_ldm_hot", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_hot_showsubcats", "adv_portal_ldm_hot", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", 0, 0);
	add_vba_setting($vba_module, "portal_ldm_hot_showcatname", "adv_portal_ldm_hot", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_showpagenav", "adv_portal_ldm_hot", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_hot.module");
	echo "Created What's Hot module\n";

// Hot media files (as flash/thumbs) module

	$vba_module = create_vba_module("Hot Media", "ldm_hot_media", $codedir."/ldm_hot_media.php", $templatedir."/ldm_hot_media.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_hot_media_showentries", "adv_portal_ldm_hot_media", "Entries", "Number of hot entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_hot_media_showthumbsize", "adv_portal_ldm_hot_media", "Thumb/Media Player Size", "Pixels", "", "100", "100");
	add_vba_setting($vba_module, "portal_ldm_hot_media_showperrow", "adv_portal_ldm_hot_media", "Per row", "Entries per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_hot_media_hitssince", "adv_portal_ldm_hot_media", "Days", "Number of days over which to count.  Set to zero to count all hits", "", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_media_showcategories", "adv_portal_ldm_hot_media", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_hot_media_showsubcats", "adv_portal_ldm_hot_media", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_media_showcatname", "adv_portal_ldm_hot_media", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_media_showpagenav", "adv_portal_ldm_hot_media", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_hot_media.module");
	echo "Created Hot Flash Thumbs module\n";

// What's Hot (as thumbs) module

	$vba_module = create_vba_module("Hot Thumbs", "ldm_hot_thumb", $codedir."/ldm_hot_thumb.php", $templatedir."/ldm_hot_thumb.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showentries", "adv_portal_ldm_hot_thumb", "Entries", "Number of hot entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showthumbsize", "adv_portal_ldm_hot_thumb", "Thumbnail size", "Pixels or %", "", "100", "100");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showperrow", "adv_portal_ldm_hot_thumb", "Per row", "Thumbs to show per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_hitssince", "adv_portal_ldm_hot_thumb", "Days", "Number of days over which to count.  Set to zero to count all hits", "", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showcategories", "adv_portal_ldm_hot_thumb", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showsubcats", "adv_portal_ldm_hot_thumb", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showcatname", "adv_portal_ldm_hot_thumb", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_hot_thumb_showpagenav", "adv_portal_ldm_hot_thumb", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_hot_thumb.module");
	echo "Created Hot Thumbs module\n";

// What's New module

	$vba_module = create_vba_module("What's New", "ldm_new", $codedir."/ldm_new.php", $templatedir."/ldm_new.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_new_showentries", "adv_portal_ldm_new", "Entries", "Number of new entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_new_showperrow", "adv_portal_ldm_new", "Per row", "Entries to show per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_new_showcategories", "adv_portal_ldm_new", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_new_showsubcats", "adv_portal_ldm_new", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_showcatname", "adv_portal_ldm_new", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_showpagenav", "adv_portal_ldm_new", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_new.module");
	echo "Created What's New module\n";

// New media files (as flash/thumbs) module

	$vba_module = create_vba_module("New Media", "ldm_new_media", $codedir."/ldm_new_media.php", $templatedir."/ldm_new_media.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_new_media_showentries", "adv_portal_ldm_new_media", "Entries", "Number of new entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_new_media_showthumbsize", "adv_portal_ldm_new_media", "Thumb/Media Player Size", "Pixels", "", "100", "100");
	add_vba_setting($vba_module, "portal_ldm_new_media_showperrow", "adv_portal_ldm_new_media", "Per row", "Entries per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_new_media_showcategories", "adv_portal_ldm_new_media", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_new_media_showsubcats", "adv_portal_ldm_new_media", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_media_showcatname", "adv_portal_ldm_new_media", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_media_showpagenav", "adv_portal_ldm_new_media", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_new_media.module");
	echo "Created New Flash Thumbs module\n";

// What's New (as thumbs) module

	$vba_module = create_vba_module("New Thumbs", "ldm_new_thumb", $codedir."/ldm_new_thumb.php", $templatedir."/ldm_new_thumb.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showentries", "adv_portal_ldm_new_thumb", "Entries", "Number of new entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showthumbsize", "adv_portal_ldm_new_thumb", "Thumbnail size", "Pixels or %", "", "100", "100");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showperrow", "adv_portal_ldm_new_thumb", "Per row", "Thumbs to show per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showcategories", "adv_portal_ldm_new_thumb", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showsubcats", "adv_portal_ldm_new_thumb", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showcatname", "adv_portal_ldm_new_thumb", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_new_thumb_showpagenav", "adv_portal_ldm_new_thumb", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_new_thumb.module");
	echo "Created New Thumbs module\n";

// Random Entries module

	$vba_module = create_vba_module("Random Entries", "ldm_random", $codedir."/ldm_random.php", $templatedir."/ldm_random.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_random_showentries", "adv_portal_ldm_random", "Entries", "Number of random entries to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_random_showperrow", "adv_portal_ldm_random", "Per row", "Entries to show per row", "", "$perrow", "$perrow");
	add_vba_setting($vba_module, "portal_ldm_random_showcategories", "adv_portal_ldm_random", "Categories", "Comma-separated list of category ids to search.  Leave blank to search all categories");
	add_vba_setting($vba_module, "portal_ldm_random_showsubcats", "adv_portal_ldm_random", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_random_showcatname", "adv_portal_ldm_random", "Show Category Name", "Include category name in listing", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_random_showpagenav", "adv_portal_ldm_random", "Show PageNav", "Include page navigator", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_random.module");
	echo "Created What's New module\n";

// Review-related modules --------------------

// New Reviews module

	$vba_module = create_vba_module("New Reviews", "ldm_new_reviews", $codedir."/ldm_new_reviews.php", $templatedir."/ldm_new_reviews.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_new_reviews_showentries", "adv_portal_ldm_new_reviews", "Entries", "Number of new reviews to display", "", "$torevw", "$torevw");
	add_vba_setting($vba_module, "portal_ldm_new_reviews_showcategories", "adv_portal_ldm_new_reviews", "Categories", "Comma-separated list of category ids to include.  Leave blank to include all categories");
	add_vba_setting($vba_module, "portal_ldm_new_reviews_showsubcats", "adv_portal_ldm_new_reviews", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_new_reviews.module");
	echo "Created New Reviews module\n";

// Newly Reviewed module

	$vba_module = create_vba_module("Newly Reviewed", "ldm_newly_reviewed", $codedir."/ldm_newly_reviewed.php", $templatedir."/ldm_newly_reviewed.xml", $ldm_linkbit_tocache);
	add_vba_setting($vba_module, "portal_ldm_newly_reviewed_showentries", "adv_portal_ldm_new_reviewed", "Entries", "Number of new reviews to display", "", "$torevw", "$torevw");
	add_vba_setting($vba_module, "portal_ldm_newly_reviewed_showcategories", "adv_portal_ldm_new_reviewed", "Categories", "Comma-separated list of category ids to include.  Leave blank to include all categories");
	add_vba_setting($vba_module, "portal_ldm_newly_reviewed_showsubcats", "adv_portal_ldm_new_reviewed", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	save_vba_module($vba_module, $outputdir."/ldm_newly_reviewed.module");
	echo "Created Newly Reviewed module\n";

// Keyword-related modules --------------------

// Tagcloud module

	$vba_module = create_vba_module("Keyword TagCloud", "ldm_tagcloud", $codedir."/ldm_tagcloud.php", $templatedir."/ldm_tagcloud.xml");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_limit", "adv_portal_ldm_tagcloud", "Top keywords", "Number of keywords to display", "", "$toshow", "$toshow");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_showcategories", "adv_portal_ldm_ldm_tagcloud", "Categories", "Comma-separated list of category ids to include.  Leave blank to include all categories");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_showsubcats", "adv_portal_ldm_new_tagcloud", "Subcategories", "Set to yes to include all subdirectories of selected categories.  Set to no to explore these categories only", "yesno", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_byhits", "adv_portal_ldm_tagcloud", "Weighting", "0=unweighted, 1=by total hits", "", "0", "0");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_logcurve", "adv_portal_ldm_tagcloud", "Logarithmic fit", "0=no, 1=yes", "", "1", "1");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_minfont", "adv_portal_ldm_tagcloud", "Minimum font size", "px", "", "10", "10");
	add_vba_setting($vba_module, "portal_ldm_tagcloud_maxfont", "adv_portal_ldm_tagcloud", "Maximum font size", "px", "", "36", "36");
	save_vba_module($vba_module, $outputdir."/ldm_tagcloud.module");
	echo "Created Tagcloud module\n";

// Utility modules --------------------

// Full search module

	$vba_module = create_vba_module("Search Downloads", "ldm_search", $codedir."/ldm_search.php", $templatedir."/ldm_search.xml");
	save_vba_module($vba_module, $outputdir."/ldm_search.module");
	echo "Created Full Search module\n";

// Total Bandwidth module

	$vba_module = create_vba_module("LDM Site Stats", "ldm_tot", $codedir."/ldm_tot.php", $templatedir."/ldm_tot.xml");
	add_vba_setting($vba_module, "portal_ldm_tot_days_seen", "adv_portal_ldm_tot", "Days", "Number of days to aggregate downloads", "", "30", "30");
	save_vba_module($vba_module, $outputdir."/ldm_tot.module");
	echo "Created LDM Site Stats module\n";

	echo "Done\n\n";

}

?>